/*global require, runScript, console, __bootStrapPath, __compiledScene, parseJSON*/
/*jshint unused: vars */
/*jshint esversion: 6 */

runScript("./nmlBootstrap.js");

(function () {
	"use strict";

	require(["lib/Zoot", "lodash", "src/build/ZoneProfiler", "lib/dev/config", "lib/tasks"],
	function (Z, lodash, ZoneProfiler, config, tasks) {
		var dependencies = [],
			rootScene,
			stage,
			rootSceneId,
			sceneJSON = {},
			sceneTerminationFuncsA = [],
			doAnimate, doSceneAnimate,
			builder = new Z.Builder(),
			CreateFactoryObjects,
			firstAnimateCalled = false,
			initAnimalTimeItem = function(inData, ioObj) { 
				ioObj.setTrimInTime(inData._trimInTime);
				ioObj.setTrimOutTime(inData._trimOutTime);
				ioObj.setDuration(inData._durationTime);
				ioObj.setParentOffsetTime(inData._parentOffsetTime);

				if (inData._minSampleTime !== undefined) {
					ioObj.setMinSampleTime(inData._minSampleTime);
				}
				if (inData._maxSampleTime !== undefined) {
					ioObj.setMaxSampleTime(inData._maxSampleTime);
				}
	
			},
			initBehaviorBag = function(ioPuppetInstance) {

				function initBBag(ioPuppetInstance) {
					var	bi, key, bbag = ioPuppetInstance._behaviorBag, childInstances, egPile, egPileItem, i;
					for (key in bbag) {
						if (bbag.hasOwnProperty(key)) {
							bi = bbag[key];
							egPile = bi._egPile;
							for (i = 0; i < egPile._aPileItems.length; i += 1) {
								egPileItem = new CreateFactoryObjects(egPile._aPileItems[i]);
								initAnimalTimeItem(egPile._aPileItems[i]._timeItem, egPileItem);
								egPile._aPileItems[i] = egPileItem;
							}
							
						}
					}
					if (ioPuppetInstance._children) {
						childInstances = ioPuppetInstance._children;
						for (key in childInstances) {
							if (childInstances.hasOwnProperty(key)) {
								initBBag(childInstances[key]);
							}
						}
					}
				}
				
				initBBag(ioPuppetInstance);
			},
			factory = {
				Scene: function(inData) {
					var s = new Z.Scene(inData._framerate, inData._pixWidth, inData._pixHeight, inData._centeredOrigin), t, tracks, track;

					s.setSimulationRateFactor(inData._simulationRateFactor);

					tracks  = inData._aTracks;
					for (t = 0; t < tracks.length; t += 1) {
						track = new CreateFactoryObjects(tracks[t]);
						s.addChild(track);
					}

					s.setTrackItemSource(new CreateFactoryObjects(inData.pPath));

					return s;
				},
				PPath: function(inData) { 
					return new Z.TrackItemSource(inData.p, inData.classInstance, inData.jsonPath);
				},
				EventGraphPileItem_: function(inData) {
					var keyframeBuckets;
					
					if (inData.tEditedKeyframeBuckets) {
						keyframeBuckets = new CreateFactoryObjects(inData.tEditedKeyframeBuckets);
					}
				    return new Z.EventGraphPileItem(inData._bEnabled, inData._bSolo, inData._blendEnvelope, inData._boundBehaviorID, inData._boundInstanceID,
														inData._paramId, inData._takeGroupID, inData.filePath, keyframeBuckets);
				},
				TrackItem: function(inData) {
					var ti, trackSource;
					
					trackSource = new CreateFactoryObjects(inData._trackSource);

					ti = new Z.TrackItem(trackSource, inData._rootTrackItemPuppet);
					initAnimalTimeItem(inData._timeItem, ti);

					initBehaviorBag(ti.getInstanceInfo());
					
					return ti;
				},
				Track: function(inData) { 
					var t = new Z.Track(inData._name), tItem, trackItems, ti;

					t.setAudibleEnabled(inData._audible);
					t.setVisibleEnabled(inData._visible);
					t.setArmedForRecord(inData._bArmedForRecord);

					trackItems  = inData._aTrackItems;
					for (ti=0; ti < trackItems.length; ti += 1) {
						tItem = new CreateFactoryObjects(trackItems[ti]);
						t.addChild(tItem);
					}

					return t;
				},
				EditedKeyframeBuckets: function(inData) {
					var duration = inData.bucketMap.nDuration, nLastBucketIndex = inData.nLastBucketIndex;

					// This doesn't really belong in the map.  It's added from lua to prevent JSON conversion to an array with a bunch of extra
					// items in it with the value of null. Apparently, our JSON converter iterates through the lua table and determining
					// whether every key is an index, then deciding it should be an array in Javascript.  -jacquave 2/22/2017
					delete inData.bucketMap.nDuration;
					
					return new Z.EditedKeyframeBuckets(inData.bucketMap, duration, nLastBucketIndex, inData.eventGraphKeyArray, inData.srcFileDuration);
				}
			};

		CreateFactoryObjects = function (inData) {
			if (inData.factoryKey) {
				if (factory[inData.factoryKey]) {
					return factory[inData.factoryKey](inData);
				}
			}
			return undefined;
		};

		function isParamArmedForRecord(inEventGraph, inBehavior, inParamId)
		{
			var armedForRecordOnB = inBehavior.trackItemBehavior._paramArmedBag[inParamId],
				p = inBehavior.params[inParamId];

			if (armedForRecordOnB === undefined) {
				armedForRecordOnB = p.defaultArmedForRecordOn || false;
			}

			if (armedForRecordOnB && p.type === "eventGraph") {
				// if this param is solely dependent on camera or audio and the hardware
				// is disabled, it isn't live.
				var cameraInputCount = 0, audioInputCount = 0, inputKeysArray = p.disarmIfAllInputKeysDisabledArray || p.inputKeysArray,
						requiredHardwareEnabledB = null;
				
				for (var j = 0; j < inputKeysArray.length; j += 1) {
					var inputKeyStr = inputKeysArray[j];
					if (inputKeyStr.startsWith("Head/")) {
						++cameraInputCount;
					} else if (inputKeyStr.startsWith("Viseme/") || inputKeyStr.startsWith("Audio/")) {
						++audioInputCount;
					} else {
						return armedForRecordOnB;
					}
				}

				if (audioInputCount > 0) {
					requiredHardwareEnabledB = inEventGraph.getGraphValue("Viseme/InputEnabled");
				}
				if (cameraInputCount > 0 && !requiredHardwareEnabledB) {
					requiredHardwareEnabledB = inEventGraph.getGraphValue("Head/InputEnabled");
				}
				
				if (requiredHardwareEnabledB !== null && !requiredHardwareEnabledB) {
					//console.log("parameter disarmed : " + p.uiName);
					return false;
				}
			}
			return armedForRecordOnB;
		}

		// FIXME (??) Investigate whether this implementation really represents layer frame relative to scene.
		// For example, the child of getDisplayContainer() is layer attacher, which suggests that layer
		// frame is the child of layer attacher and not a child of getDisplayContainer()
		function getLayerMatrixRelativeToScene (layer, result0) {
			var result = result0 || [],
				cLayer = layer.getDisplayContainer(),
				// TODO: should be relative to scene but we don't have that container yet
				// cScene = this.scene_.getDisplayContainer(),
				// instead will use whatever is at the root
				cScene = null;

			if (cLayer) return cLayer.getMatrixRelativeTo(cScene, result);

			return Z.Mat3.identity(result);
		}

		/* unused 
		function getPuppetMatrixRelativeToScene (layer, result0) {
			var result = result0 || [],
				cPuppet = layer.getWarperContainer(),
				cScene = null;

			if (cPuppet) return cPuppet.getMatrixRelativeTo(cScene, result);

			return Z.Mat3.identity(result);
		} */

		// FIXME: The above getLayerMatrixRelativeToScene is a key function (although this doesn't seem like the right place for it.).
		// However these two should go away as they apppear to be redundant with getFrameRelativeToLayer or multiplication with matScene_Layer.
		var getHandleMatrix, getHandleMatrixRelativeToScene;

		getHandleMatrix = function getHandleMatrix (handle) {
			return tasks.handle.getFrameRelativeToLayer(handle);
		};

		getHandleMatrixRelativeToScene = function getHandleMatrixRelativeToScene (handle, result0) {
			/*jshint validthis: true*/ // Use call() to reuse in mixins.
			var warper = handle.getWarperLayer(),
				matScene_Warper = this.getLayerMatrixRelativeToScene(warper),
				matWarper_Handle = tasks.handle.getFrameRelativeToLayer(handle);

			return Z.Mat3.multiply(matScene_Warper, matWarper_Handle, result0);
		};

		function BehaviorParamBlock (inScene, inBehavior, inBehaviorInstanceId, inEventGraph, inTimeStack, inGlobalRehearseTime, inRehearseTime, inBehaviorLiveB, inStagePuppet, inEventGraphEvaluators) {
			var timeSpan = inTimeStack.getLocalTimeSpan();
			this.scene_ = inScene;
			this.behavior = inBehavior;
			this.behaviorInstanceId = inBehaviorInstanceId;
			this.eventGraph = inEventGraph;
			this.timeStack = inTimeStack;
			this.t = timeSpan.t;
			this.dt = timeSpan.dt;
			this.globalRehearseTime = inGlobalRehearseTime;
			this.rehearseTime = inRehearseTime;
			this.behaviorLiveB = inBehaviorLiveB;
			this.stagePuppet = inStagePuppet;
			this.stageLayer = inStagePuppet.getParentLayer().getSdkLayer();	// layer whose source is the stage puppet -- for starting recursive walks
			this.eventGraphEvaluators = inEventGraphEvaluators;
			this.cachedValuesMap0 = {};
			this.cachedParamLiveMap0 = {};
		}

		function getValueFromParamEvaluator(inGraphEvaluator, inId, inParam, inParamBlock)
		{
			var i, egk, v, t = inParamBlock.getEvaluationTime(inGraphEvaluator, inId);
			// check in order from specific to general -- this is needed for param inheritance
			if (inParam.eventGraphValueKeyArray) {
				for (i = inParam.eventGraphValueKeyArray.length-1; i >= 0; i -= 1) {
					egk = inParam.eventGraphValueKeyArray[i];
					if (egk) {
						v = inGraphEvaluator.getValue("Param" + egk, t);
						if (v !== undefined) {
							return v;
						}
					}
				}
			}
		}
		
		function getValueFromParamEventEvaluator (inEventName)
		{
			return function (inGraphEvaluator, inId, inParam, inParamBlock)
			{
				return 	inParamBlock.getParamEventValueFromEvaluator(inGraphEvaluator, inId, inEventName);
			};
		}
		
		function getMatrixFromParamEventEvaluator (inParentEventName)
		{
			return function (inGraphEvaluator, inId, inParam, inParamBlock)
			{
				var t = inParamBlock.getEvaluationTime(inGraphEvaluator, inId, true);

				if (t !== undefined) {
					return inGraphEvaluator.getGraphMatrix(inParentEventName, t);
				}
				return undefined;
			};
		}		

		function getBlendedValue(inValue0, inWeight, inDefaultValue)
		{
			var	value = (inValue0 !== undefined) ? inValue0 : inDefaultValue;
			return Z.mathUtils.multiplyByScalar(value, inWeight);
		}

		function forEachLayerBehaviorIteration (inRootLayer, inFunc, inBehaviorId, inDoNotIncludeParentLayerWithSameBehaviorB0) {
			return inRootLayer.forEachLayerBreadthFirst(function (sdkLayer) {
				// Possibly skip sublayers with the same behavior
			    if (inRootLayer !== sdkLayer) {
					var puppet0 = sdkLayer.getPuppet();
					if (puppet0 && puppet0.isBehaviorApplied(inBehaviorId)) {
						var fnResult0,
							myFnResult = {continueB:true, includeChildrenB:false};							// Skip its children, but continue iterating.

						if (!inDoNotIncludeParentLayerWithSameBehaviorB0) {
							fnResult0 = inFunc(sdkLayer);	// Call it on this layer
						}

						if (fnResult0 !== undefined) {
							// Allow this layer's function result to override whether we continue, but not whether we include the children.
							if (lodash.isObject(fnResult0)) {
								myFnResult.continueB = (fnResult0.continueB !== false);	// undefined means continue
							} else {
								myFnResult.continueB = (fnResult0 !== false);
							}
						}
						// Skip its children, but continue iterating.
						return myFnResult; 
					}
				}
				return inFunc(sdkLayer);
			});
		}

		function forEachTrackItemPuppetIteration (inTime, inScene, inFunc) {
            
            var rootSdkLayer,
                trackPuppets = getTrackPuppets(inTime, inScene);

            trackPuppets.forEach(function (p) {             
                rootSdkLayer = p.getParentLayer().getSdkLayer();

                // var rootLayer = rootSdkLayer.privateLayer;
                // console.logToUser("At time " + inTime + " this layer is active " + rootLayer.getStageId());

                return inFunc(rootSdkLayer);
            });
            // console.logToUser("forEachActivePuppetIteration");
        }

		function forEachPuppetIteration (inTime, inScene, inFunc) {
			
			var rootSdkLayer,
				trackPuppets = getTrackPuppets(inTime, inScene);

			trackPuppets.forEach(function (p) {				
				rootSdkLayer = p.getParentLayer().getSdkLayer();
					
				rootSdkLayer.forEachLayerBreadthFirst(function (sdkLayer) {

					//var layer = sdkLayer.privateLayer;
					//console.logToUser("forEachPuppetIteration called for :" +  layer.getName());

					return inFunc(sdkLayer);
				});
			});
			// console.logToUser("forEachActivePuppetIteration");
		}

		
		// methods on the param block
		Z.utils.mixin(BehaviorParamBlock, {
			
			getParamData : function (inId) {
				var paramParent = this.behavior.pGetParams(), p;
				
				p = paramParent[inId];

				if (p) {
					return p;
				} else {
					throw new Error("Behavior " + this.behavior.behaviorPPath + " missing parameter ID '" + inId + "'");
				}
			},
			
			getEvaluationTime : function (inGraphEvaluator, inId, inLocalOrLiveOnlyB) {
			    var globalEvalB = inGraphEvaluator.evaluatesAtGlobalTime(),
					liveB = this.isParamEventLive(inId), t;

				if (!inLocalOrLiveOnlyB || (!globalEvalB || liveB)) {
					t = inGraphEvaluator.getTimeSpan(this.timeStack).t + 
							(globalEvalB ? this.globalRehearseTime : (liveB ? this.rehearseTime : 0.0));
					
					Z.utils.assert(globalEvalB || (!liveB || (this.globalRehearseTime === this.rehearseTime)), "bad rehearsal time");
				}
				return t;
			},

			getEvaluatorsValueWeightData : function (inId, inNormalizeIndividualWeightsB, inGraphEvaluatorArray, inGetValueFromParameterFunc0) {
				var p = this.getParamData(inId), i, blendableB = this.isParamBlendable(p);

				var weightValueArray = [], totalWeightF = 0.0, atLeastOneValidValueB = false, compositeWeightsA;

				if (inGraphEvaluatorArray.length > 0) {
					totalWeightF = inGraphEvaluatorArray[0].getBlendWeight();
				}

				for (i = 0; i < inGraphEvaluatorArray.length; i = i + 1) {
					var value0 = inGetValueFromParameterFunc0 && inGetValueFromParameterFunc0(inGraphEvaluatorArray[i], inId, p, this), weightF;

					if (value0 !== undefined) {
						atLeastOneValidValueB = true;
					}
					weightF = inGraphEvaluatorArray[i].getBlendWeight();
					if (i !== 0) {
						compositeWeightsA = Z.mathUtils.getCompositeWeights(totalWeightF, weightF);
						if (inNormalizeIndividualWeightsB) {
							weightF = compositeWeightsA[1];
						}
						totalWeightF = compositeWeightsA[0] + compositeWeightsA[1];
					}

					weightValueArray.push({value0:value0, weight:weightF});
					if (!blendableB || totalWeightF >= 1.0) {
						break;
					}
				}
				return { weightValueArray : weightValueArray, totalWeightF : totalWeightF, atLeastOneValidValueB : atLeastOneValidValueB };
			},

			getValueDataFromEvaluatorsArray : function (inId, inGraphEvaluatorArray, inGetValueFromParameterFunc,
													inDefaultValue, inUndefinedOkB0) {
				var valueData = {}, p = this.getParamData(inId), i, blendableB = this.isParamBlendable(p);

				var weightValueArray, weightValueArrayData, totalWeightF = 0.0, atLeastOneValidValueB;

				weightValueArrayData = this.getEvaluatorsValueWeightData(inId, false, inGraphEvaluatorArray, inGetValueFromParameterFunc);
				weightValueArray = weightValueArrayData.weightValueArray;
				atLeastOneValidValueB = weightValueArrayData.atLeastOneValidValueB;
				totalWeightF = weightValueArrayData.totalWeightF;

				if (inUndefinedOkB0 && !atLeastOneValidValueB) {
					valueData.value = undefined;
				} else {
					if (weightValueArray.length) {
						if (blendableB) {
							// If some of these items are undefined, there is no way to avoid
							// discontinuities as it becomes enabled.  Use the default value
							// anywhere the value is undefined.

							// Use getCompositeWeights to get each weight for A over B.
							totalWeightF = weightValueArray[0].weight;
							var v = getBlendedValue(weightValueArray[0].value0, weightValueArray[0].weight, inDefaultValue),
									compositeWeightsA;

							for (i = 1; i< weightValueArray.length; i = i + 1) { // two at a time.
								compositeWeightsA = Z.mathUtils.getCompositeWeights(totalWeightF, weightValueArray[i].weight);

								v = Z.mathUtils.add(getBlendedValue(weightValueArray[i].value0, compositeWeightsA[1], inDefaultValue), v);
								totalWeightF = compositeWeightsA[0] + compositeWeightsA[1];
								if (totalWeightF >= 1.0) break;
							}

							if (totalWeightF < 1.0) {
								v = Z.mathUtils.add(Z.mathUtils.multiplyByScalar(inDefaultValue, 1.0-totalWeightF), v);
								totalWeightF = 1.0;
							}
							valueData.value = v;
						} else if (weightValueArray[0].value0 !== undefined) {
							// weights are ignored, top wins.
							valueData.value = weightValueArray[0].value0;
							totalWeightF = 1.0;
						}
					}

					if (valueData.value === undefined) {
						valueData.value = inDefaultValue;
					}
				}
				valueData.weightF = totalWeightF;
				return valueData;
			},			

			getGraphEvaluatorArray : function (inParamId, inTakeGroupId0) {
				var paramAndTakeGroupId = Z.EventGraphPileItem.formulateEventGraphParamAndTakeGroupId(inParamId, inTakeGroupId0);
				if (!this.eventGraphEvaluators[paramAndTakeGroupId]) {
					this.eventGraphEvaluators[paramAndTakeGroupId] = [this.eventGraph.getEvaluator(this.behaviorInstanceId)];
				}

				return this.eventGraphEvaluators[paramAndTakeGroupId];
			},

			isParamBlendable : function (inParam) {
				var blendableB = inParam.type === "slider" || inParam.type === "angle";
				
				if (!blendableB && inParam.type === "eventGraph") {
					blendableB = inParam.supportsBlending || false;
				}
				return blendableB;
			},

			getParam : function (inId) {
			    var p = this.getParamData(inId);

				if (this.cachedValuesMap0[inId] === undefined) {
					var defaultValue = p.value;
					if (defaultValue !== undefined && p.type === "checkbox") {
						defaultValue = Number(defaultValue);
					}
					if (p.eventGraphValueKeyArray) {
						var graphEvaluatorArray = this.getGraphEvaluatorArray(inId, null);
						this.cachedValuesMap0[inId] = this.getValueDataFromEvaluatorsArray(inId, graphEvaluatorArray, getValueFromParamEvaluator, defaultValue).value;
					} else {
						this.cachedValuesMap0[inId] = defaultValue;
					}
				}
				return this.cachedValuesMap0[inId];
			},

            getParamEventOutputKey : function(inId) {
            	var keyPrefix = "BehaviorOutput/" + this.behavior.behaviorId + "/" + inId + "/" + this.behaviorInstanceId + "/";
                return keyPrefix;
            },

            getParamEventOutputForHandleKey : function(inId, inHandle) {
				var	handleBackstageId = inHandle.getDagPathId(), keyPrefix = "HandleTarget/" + handleBackstageId + "/";
                return keyPrefix;
            },

            getParamEventOutputForTriggerGroup : function(inTriggerGroupId) {
				var	keyPrefix = "TriggerGroup/" + inTriggerGroupId;
                return keyPrefix;
            },

			// Needed by Dragger 2.  Can be deleted after we decide to no longer
			// support dragger recordings created in Preview 3.
            getOldParamEventOutputForHandleKey : function(inId, inHandle) {
				var	handleBackstageId = inHandle.getDagPathIdOld(), keyPrefix = "HandleTarget/" + handleBackstageId + "/";
                return keyPrefix;
            },

			getParamEventEvaluatorArray : function (inId, inEventName, inTakeGroupId0) {
				var paramParent = this.behavior.pGetParams(), p, j, foundParamKeyB = false;
				
				p = paramParent[inId];
				
				Z.utils.assert(p.type === "eventGraph");
				
				for (j = 0; j < p.inputKeysArray.length; j += 1) {
					if (inEventName.indexOf(p.inputKeysArray[j]) === 0) {
						foundParamKeyB = true;
						break;
					}
				}
				
				if (!foundParamKeyB && p.outputKeyTraits && p.outputKeyTraits.takeGroupsArray) {
				    var outputPrefixKey = this.getParamEventOutputKey(inId), takeGroupsArray = p.outputKeyTraits.takeGroupsArray;
				    for (j = 0; j < takeGroupsArray.length; j += 1) {
				        var keyId = takeGroupsArray[j].id, wildCardIndex = keyId.indexOf("/*");
				        if (wildCardIndex > -1) {
				            keyId = keyId.substring(0, wildCardIndex+1);
				        }
				        if (inEventName.indexOf(outputPrefixKey + keyId) === 0) {
							foundParamKeyB = true;
							break;
						}
					}
				}
				
				Z.utils.assert(foundParamKeyB, inEventName + " not found in inputKeysArray when calling getParamEventValue");

				return this.getGraphEvaluatorArray(inId, inTakeGroupId0);
			},
			
			getParamEventValueFromEvaluator : function (inGraphEvaluator, inId, inEventName)
			{
				var t = this.getEvaluationTime(inGraphEvaluator, inId, true);

				if (t !== undefined) {
					return inGraphEvaluator.getValue(inEventName, t);
				}
				return undefined;
			},
			
			isParamEventLive: function (inId) {
				if (this.behaviorLiveB) {
					var cachedParamLiveValue0 = this.cachedParamLiveMap0[inId];
					if (cachedParamLiveValue0 !== undefined) return cachedParamLiveValue0;

					var armedForRecordOnB = isParamArmedForRecord(this.eventGraph, this.behavior, inId);
					this.cachedParamLiveMap0[inId] = armedForRecordOnB;
					return armedForRecordOnB;
				}
				return false;
			},

			verifyParamEventEvaluation : function (inParam, inDefaultValue0) {
				var blendableB = this.isParamBlendable(inParam);
				Z.utils.assert(inDefaultValue0 === undefined || blendableB,
							   	"Do not call getParamEventFunction with a default value if the parameter is not blendable");
				Z.utils.assert(inDefaultValue0 !== undefined || !blendableB,
							   	"The behavior must call getParamEventFunction with a default value if the parameter is blendable");
			},

			getParamEventValue : function (inId, inEventName, inTakeGroupId0, inDefaultValue0, inUndefinedOkB0) {
			    var graphEvaluatorArray = this.getParamEventEvaluatorArray(inId, inEventName, inTakeGroupId0),
					p = this.getParamData(inId);
				
				this.verifyParamEventEvaluation(p, inDefaultValue0);
				return this.getValueDataFromEvaluatorsArray(inId, graphEvaluatorArray, getValueFromParamEventEvaluator(inEventName),
												   inDefaultValue0, inUndefinedOkB0).value;
			},
			
			getParamEventValueWeightData : function (inId, inNormalizeIndividualWeightsB, inEventName, inTakeGroupId0) {
			    var graphEvaluatorArray = this.getParamEventEvaluatorArray(inId, inEventName, inTakeGroupId0);
				
				return this.getEvaluatorsValueWeightData(inId, inNormalizeIndividualWeightsB, graphEvaluatorArray, getValueFromParamEventEvaluator(inEventName));
			},
			
			getParamEventMatrix : function (inId, inParentEventName, inTakeGroupId0, inDefaultMatrix0, inUndefinedOkB0) {
			    var graphEvaluatorArray = this.getParamEventEvaluatorArray(inId, inParentEventName, inTakeGroupId0),
					p = this.getParamData(inId);
				this.verifyParamEventEvaluation(p, inDefaultMatrix0);
				return this.getValueDataFromEvaluatorsArray(inId, graphEvaluatorArray, getMatrixFromParamEventEvaluator(inParentEventName),
												   inDefaultMatrix0, inUndefinedOkB0).value;
			},
			
			setEventGraphParamRecordingValid : function (inId, inTakeGroupId0) 
			{
				if (this.isParamEventLive(inId)) {
					stage.setEventGraphParamRecordingValid(this.behaviorInstanceId, inId, inTakeGroupId0);
				}
			},

			getLayerMatrixRelativeToScene : function (layer, result0) {
				return getLayerMatrixRelativeToScene.call(this, layer, result0);
			},

			getHandleMatrixRelativeToScene : function (handle, result0) {
				return getHandleMatrixRelativeToScene.call(this, handle, result0);
			},
			
			getHandleMatrix : function (handle) {
				return getHandleMatrix(handle);
			},
			
			getClosestTriggerableParent : function () {
				var lay = this.stageLayer;

				while (lay && !lay.privateLayer.getTriggerable()) { // find closest triggerable
					lay = lay.getParentLayer();
				}
				
				return lay;
			},
			
			// returns sdk layer that triggered this behavior (one of its parents), or null if not triggered
			getTriggeringLayer : function () {
				var lay = this.getClosestTriggerableParent();

				return (lay && lay.getTriggered()) ? lay : null;
			},
            
            // returns false or one of "sustainedTrigger", "realTrigger", "behaviorTrigger"
            getTriggeringType : function () {
                var lay = this.getTriggeringLayer();
                
                if (lay) {
                    var triggeredBySet = lay.triggeredByObjSet0;
                    if (triggeredBySet) {
                        var bAtLeastOneReal = false;
                        
                        // logic below only works for 1+ items, which is always the case right now
                        Z.utils.assert(triggeredBySet.size > 0, "unexpectedly empty triggered-by set");
                        
						triggeredBySet.forEach(function (triggerObj) {
                            if (!triggerObj.bWasRetriggered) {
                                bAtLeastOneReal = true;
                            }
                        });
                        
                        if (bAtLeastOneReal) {
                            // if this layer has a mix of real & sustained, it's classified as real -- TODO: is that what we want?
							return "realTrigger";
						} else {
							return "retrigger";      // someone called retriggerOnNextFrame()
						}
                    } else {
                        return "behaviorTrigger";   // triggered by a behavior other than Triggers
                    }
                }
                
                return false;
            },
			
			sustainTrigger : function (priority0) {
				var lay = this.getClosestTriggerableParent();
				
				Z.utils.assert(lay, "sustainTrigger needs a layer");
				
                lay.trigger(priority0);
			},
			
			retriggerOnNextFrame : function (priority0) {
				var lay = this.getClosestTriggerableParent();
				
				Z.utils.assert(lay, "retrigger needs a layer");
				
                if (lay.triggeredByObjSet0) {
                    lay.triggeredByObjSet0.forEach(function (triggerObj) {
						triggerObj.bRetrigger = true;
						triggerObj.retriggerPriority = priority0;
					});
                }
			},
			
			forEachLayerInTree : function (inFunc) {
				forEachLayerBehaviorIteration(this.stageLayer, inFunc, this.behavior.behaviorId);
			},

			forEachLayerInTreeLegacy : function (inFunc) {
				forEachLayerBehaviorIteration(this.stageLayer, inFunc, this.behavior.behaviorId, true);
			},

			forEachTrackItemPuppet : function (inTime, inFunc, inScene0) { // for each active trackitem puppet
                forEachTrackItemPuppetIteration(inTime, inScene0 || this.scene_, inFunc);
            },

			forEachPuppet : function (inTime, inFunc, inScene0) { // for each active puppet
				forEachPuppetIteration(inTime, inScene0 || this.scene_, inFunc);
			}
		});


		function CreateStageBehaviorParamBlock (inBehavior, inBackstageBehavior, inStagePuppet)
		{
			this.behavior = inBehavior;
			// this.backstageBehavior = inBackstageBehavior; no one needs this yet, let's not send it
			this.stagePuppet = inStagePuppet;
			this.stageLayer = inStagePuppet.getParentLayer().getSdkLayer();
		}

		// methods on the param block
		Z.utils.mixin(CreateStageBehaviorParamBlock, {
		
		/* now disabled in favor of doing this on the Lua side, but in the future when we start doing more advanced
			dynamic puppet creation & rigging on the stage itself, this may be useful for late-binding
			the layer params

			// returns (possibly empty) list of layers that match the pseudo-Xpath, starting at the layer whose source is the puppet that owns this behavior
			resolveLayerParam: function (dephault, inMaxCount0)
			{
				var xpath = dephault.match, regexp, caseInsensitive = "i", aRoots = [], aStarts, aResults = [];
				
				aRoots[0] = this.stagePuppet.parentLayer; // only Layers jam this field in their source
				
				if (aRoots[0] === undefined) {
					aRoots[0] = this.stagePuppet.getParent(); // TrackItem in this case
				}
				
				if (dephault.startMatchingAtParam) {
					// NOTE: NOT YET TESTED
					aStarts = this.getStaticParam(dephault.startMatchingAtParam); // public API
					// convert from sdk to our notion of layer; note: if other param has no matches, we will also have none
					aRoots = lodash.map(aStarts, function (lay) {
						return lay.privateLayer;
					});
				}

				// so far we just support dot and "anywhere" notation
				if (xpath === ".") {
					aResults = aRoots;
				} else {
					if (xpath.indexOf("//") === 0) {
						// TODO: this is supposed to be full-name-match only, but currently allows arbitrary text at the
						//	end of the name, until we can strip the (b!) notation into an attribute

						// TODO: use stringToRegExp() to escape metachars
						regexp = new RegExp("^" + xpath.substr(2), caseInsensitive);
					} else {
						throw new Error("Unsupported behavior layer param syntax: " + xpath);
					}

					aRoots.forEach(function (rootLayer) {
						rootLayer.breadthFirstEachLayer(function (layer) {
							if (regexp.test(layer.getName()) || regexp.test(layer.getSource().getName())) {
								aResults.push(layer);
								if (inMaxCount0 && aResults.length >= inMaxCount0) {
									return false; // ends recursion
								}
							}
						});
					});
				}
				
				// convert from internal Layer/TrackItem to SdkLayer
				return lodash.map(aResults, function (lay) {
					return lay.getSdkLayer();
				});
			},
		*/

			getStaticParam : function (inId) {	// same params as getParam now that getParam doesn't take a time -- but needs factoring, and
												//	worth noting that the results from this version can be cached forever, not true during onAnimate
				var params = this.behavior.pGetParams(), p, v;
				
				p = params[inId];
				
				if (p) {
					v = p.value;
					if (v === undefined) {
						throw new Error("Behavior " + this.behavior.behaviorPPath + " missing value for static parameter ID '" + inId + "'");
					} else if (typeof(v) === "object") {
						return lodash.clone(v); // can't cloneDeep because it would destroy the prototypes & identity of the Layers inside,
												//	so we just clone the outer shell and ask that behaviors treat it as read-only anyway.
												//	we could get one more layer of safety by cloning the dagPath (which is currently just a plain
												//	array), but that might change in the future. So we just clone the outer array. If we start
												//	having a .value datatype that's a complex object, we'll need more code here to distinguish.
					} else {
						return v;
					}
				} else {
					throw new Error("Behavior " + this.behavior.behaviorPPath + " missing static parameter ID '" + inId + "'");
				}
			},

			getLayerMatrixRelativeToScene : function (layer, result0) {
				return getLayerMatrixRelativeToScene.call(this, layer, result0);
			},

			getHandleMatrixRelativeToScene : function (handle, result0) {
				return getHandleMatrixRelativeToScene.call(this, handle, result0);
			},

			getHandleMatrix : function (handle) {
				return getHandleMatrix(handle);
			},

			forEachLayerInTree : function (inFunc) {
				forEachLayerBehaviorIteration(this.stageLayer, inFunc, this.behavior.behaviorId);
			},
			
			forEachLayerInTreeLegacy : function (inFunc) {
				forEachLayerBehaviorIteration(this.stageLayer, inFunc, this.behavior.behaviorId, true);
			},
			
			addSceneTerminationFunction : function (inFunc) {
				sceneTerminationFuncsA.push(inFunc);
			}
		});
		
		
		function log (str)
		{
			// console.log(str); // uncomment to turn on a bunch of logging in this file
		}

		function failFn()
		{
			console.log("failed to parse behavior/parameters JSON dictionary");
		}

		function stripExtension (stringIn)
		{
			return stringIn.substr(0, stringIn.lastIndexOf(".")) || stringIn;
		}

		/*function getCPathComponentString (inCPath)
		{
			var index = inCPath.indexOf(":");

			if (index === -1) {
				throw new SyntaxError("Invalid CPath");
			}

			return inCPath.substr(index+1);
		}*/
		
		function addParameterIdToCPath(inEventGraphKey, inId) {
			if (inEventGraphKey === undefined) {
				throw new SyntaxError("Invalid parameter id for CPath");
			}
			return inEventGraphKey + ":_parameter" + ":" + inId;
		}
		
		function addParameterIdToTrackItemBehavior(inBehaviorInstanceId) {
			return function(inEventGraphKey, inId) {
				if (inEventGraphKey === undefined) {
					throw new SyntaxError("Invalid parameter id for CPath");
				}
				var result = inEventGraphKey + inId;
				if (inBehaviorInstanceId) {
					result = result + "/" + inBehaviorInstanceId;
				}
				return result;
			};
		}

		function parseAudioFile (audioFilePath, trackCPath)
		{
			var audioFile = {}, audioFileJSON;

			parseJSON(audioFilePath, function successFn(inData) { audioFileJSON = inData; }, failFn);

			audioFile.filePath = audioFileJSON.filePath;
			audioFile.recordedSpeed = audioFileJSON.recordedSpeed;

			return audioFile;
		}
				
		
		function resolveDagPathToSdkLayer (stagePuppet, dagPath)
		{
			var pup = stagePuppet, layer = stagePuppet.getParentLayer();
			
			dagPath.forEach(function (layerID) {
				layer = pup.getLayerByID(layerID);
				pup = layer.getPuppet(); // i.e. the source of the layer if a puppet, else null
			});
				
			return layer.getSdkLayer();
		}
		
		
		function resolveStageBehaviorLayerAndHandleParameters (stagePuppet, stageBehavior)
		{
			// for each layer parameter, convert the array of dagPaths into an array of layers. 
			//	Because of getResolvedParams() on the lua side we can count on all layer params
			//	existing at the bound behavior level (no inheritance from project, and no overriding
			//	by the track item), so no need to loop over the inherited set of all params.
			var params = stageBehavior.pGetParams(), param;
			
			function resolveDagPath(dagPath) { // define closure outside of loop
				return resolveDagPathToSdkLayer(stagePuppet, dagPath);
			}
			
			function resolveHandle(pair) {
				var puppet, handle,
					match = pair.sHandleName,
					layer = resolveDagPathToSdkLayer(stagePuppet, pair.dagPath);
				
				puppet = layer.getPuppet();
				
				// lookup handle by name
				// TODO: update to operate on Layer instead of Puppet.  as is, it will not resolve handle in subpuppets that warp with parent.
				puppet.getHandleTreeRoot().preOrderEach(function (h) { // order here shouldn't matter, name is unique
					if (h.getName() === match) {
						handle = h;
						return false; // break iteration
					}
				});

				return handle;
			}
			
			function resolveArrayOfDagPaths (aDagPaths) {
				return lodash.map(aDagPaths, resolveDagPath);
			}
			
			function resolveArrayOfHandles (aPairs) {
				return lodash.map(aPairs, resolveHandle);
			}
			
			for (var id in params) {
				if (params.hasOwnProperty(id)) {
					param = params[id];
					if (param.type === "layer") {
						if (param.dephault.startMatchingAtParam) {
							// array of array of dagPaths -> array of array of SdkLayers
							param.value = lodash.map(param.value, resolveArrayOfDagPaths);
						} else {
							// array of dagPaths -> array of SdkLayers
							param.value = resolveArrayOfDagPaths(param.value);
						}
					} else if (param.type === "handle") {
						if (param.dephault.startMatchingAtParam) {
							// array of array of { dagPath, sHandleName } -> array of array of Handles
							param.value = lodash.map(param.value, resolveArrayOfHandles);
						} else {
							// array of { dagPath, sHandleName } -> array of Handles
							param.value = resolveArrayOfHandles(param.value);
						}
					}
				}
			}
		}



		function parseScene (scenePath, trackCPath, trackItem0)
		{
			var scene, parseChildrenFunc, sceneData, isRootSceneB = false;

			parseJSON(scenePath, function successFn(inData) { sceneJSON = inData; }, failFn);

			scene = new CreateFactoryObjects(sceneJSON);
			
			if (trackItem0) {
				scene.setParent(trackItem0);
			} else {
				isRootSceneB = true;
			}

			if (trackCPath === undefined) {
				trackCPath = scene.getTrackItemSource().getPPathString();
			}

			log("sceneJSON factoryKey = " + sceneJSON.factoryKey);
			log("scene frame rate = " + scene.getFrameRate() + " FPS");
			log("scene simulation frame rate = " + scene.getFrameRate() * scene.getSimulationRateFactor() + " FPS");
			log("scene trackItemSource String = " + scene.getTrackItemSource().getPPathString());

			if (stage === undefined) {
				rootSceneId = scene.getTrackItemSource().getPPathString();
				
				stage = Z.nml.getStage(rootSceneId);
				
				sceneData = {	frameRate				:	scene.getFrameRate(),
								pixWidth				:	scene.getPixelWidth(), 
								pixHeight				:	scene.getPixelHeight(),
								simulationRateFactor	:	scene.getSimulationRateFactor(),
							 	centeredOrigin			:	scene.isOriginCentered(),
								curtainsOpen			:	false,
								bootStrapPath			:	__bootStrapPath};

				if (!stage) {
					stage = Z.nml.newStage(rootSceneId, sceneData);
					stage.setCurtainsOpen(false);
					Z.nml.initEventGraph(rootSceneId, stage);
				} else {
					stage.setCurtainsOpen(false);
					stage.reboot(sceneData);
				}
            }

			function prepPuppetBehaviors (puppet, trackCPath) 
			{   
				var d, additionalDeps = dependencies.slice(), behaviorStart = dependencies.length, aBehaviors;

				aBehaviors = puppet.getBehaviors();

				log(JSON.stringify(aBehaviors));
				for (d = 0 ; d < aBehaviors.length; d += 1) {
					additionalDeps.push(stripExtension(aBehaviors[d].behaviorRef));
				}

				require(additionalDeps, function () {

					function prepBehaviors(varArgs)
					{
						log("prepBehaviors");

						var behaviorJSModules = varArgs.slice(behaviorStart),
							numBehaviors = behaviorJSModules.length,
							backstageBehaviorsArray = [],
							j=0,
							backstageBehavior = {},
							projBehavior = {},
							stageBehavior = {},
							stageBehaviorsArray = [],
							dispatchProperty, dispatchProperties = [];


						log("scene = " + scene);

						// base params
						for (j = 0; j < numBehaviors; j += 1) {
							projBehavior = new Z.AbstractBehavior("projectBehavior");
							backstageBehavior = new Z.AbstractBehavior("backstageBehavior");

							projBehavior.pSetParams(Z.behaviorUtils.arrayParamsToIDParams(aBehaviors[j].aProjectBehaviorParams)); // full set

							// Don't pass an event graph key, not updating based on project behavior changes anymore.
							backstageBehavior.pSetParams(Z.behaviorUtils.makeSkeletonParams(projBehavior.pGetParams()));	// sparse
							Z.behaviorUtils.mergeParams(aBehaviors[j].puppetBehaviorParams, aBehaviors[j].puppetBehaviorCPath, addParameterIdToCPath, backstageBehavior.pGetParams());

							backstageBehaviorsArray.push(backstageBehavior);
						}


						for (j = 0; j < numBehaviors; j += 1) {
							log(JSON.stringify(backstageBehaviorsArray[j].pGetParams()));
						}

						for (j = 0; j < numBehaviors; j += 1) {
							var func = behaviorJSModules[j].onCreateBackStageBehavior;
							dispatchProperty = func ? func(backstageBehaviorsArray[j]) : false;
							dispatchProperty = dispatchProperty || { 
								order : 1.0,
								importance : 0.0
							};
							dispatchProperty.index = j;  // points to corresponding module/behavior
							dispatchProperties.push(dispatchProperty);
						}

						for (j = 0; j < numBehaviors; j += 1) {
							stageBehavior = new Z.AbstractBehavior("stageBehavior");

							stageBehavior.behaviorPPath = aBehaviors[j].behaviorPPath;
							stageBehavior.behaviorId = stageBehavior.behaviorPPath.substr(stageBehavior.behaviorPPath.lastIndexOf("/")+1) || stageBehavior.behaviorPPath;
							stageBehavior.boundBehaviorArrayId = aBehaviors[j].boundBehaviorArrayID; // for consistency, ID caps in lua, camelcase in JS 
							stageBehavior.puppetBehaviorCPath = aBehaviors[j].puppetBehaviorCPath;
							//stageBehavior.trackBehaviorCPath = trackCPath + ":" + getCPathComponentString(stageBehavior.puppetBehaviorCPath);
							stageBehavior.pSetParams(Z.behaviorUtils.makeSkeletonParams(backstageBehaviorsArray[j].pGetParams()));
							// TODO:  Need to merge these parameters and use the correct CPath for the eventGraphKey -jacquave
							stageBehavior.backstageBehavior = backstageBehaviorsArray[j];
							stageBehavior.behaviorJSModule = behaviorJSModules[j];
							
							resolveStageBehaviorLayerAndHandleParameters(puppet, stageBehavior);
							
							stageBehaviorsArray.push(stageBehavior);
						}

						dispatchProperties.sort(function(p, q) { return p.order - q.order; });
						puppet.behaviorJSModules = [];
						puppet.stageBehaviorsArray = [];
						dispatchProperties.forEach(function (p) {
							puppet.behaviorJSModules.push(behaviorJSModules[p.index]);
							puppet.stageBehaviorsArray.push(stageBehaviorsArray[p.index]);
						});
						puppet.trackCPath = trackCPath;
					}

					var args = Array.prototype.slice.call(arguments);
					prepBehaviors(args);
				});
			}
			
			function prepPuppetBehaviorInstances (inPuppet, inInstanceInfo, isRootSceneB0)
			{
				var stageArrayIdtoIndex = {};

				inPuppet.behaviorBag = inInstanceInfo._behaviorBag;

				// For visible stage behaviors, call onCreateStageBehavior
				var numBehaviors = inPuppet.stageBehaviorsArray && inPuppet.stageBehaviorsArray.length, activeStageBehaviorsArray = [];
				for (var j = 0; j < numBehaviors; j += 1) {
					var puppetStageBehavior = inPuppet.stageBehaviorsArray[j], args, 
							trackItemBehavior = inPuppet.behaviorBag[puppetStageBehavior.boundBehaviorArrayId],
							behaviorInstanceId;
					
					behaviorInstanceId = trackItemBehavior && trackItemBehavior._instanceID;
					if (!behaviorInstanceId) {
						continue;		// eyeball off behavior
					}

					activeStageBehaviorsArray.push(puppetStageBehavior);
					args = new CreateStageBehaviorParamBlock(puppetStageBehavior, puppetStageBehavior.backstageBehavior, inPuppet);
					puppetStageBehavior.behaviorJSModule.onCreateStageBehavior(puppetStageBehavior, args);
				}

				inPuppet.stageBehaviorsArray[j] = activeStageBehaviorsArray;	// Thatched.
			
				// Create Array ID to Index table
				for (j = 0; j < inPuppet.stageBehaviorsArray.length; j += 1) {
					stageArrayIdtoIndex[inPuppet.stageBehaviorsArray[j].boundBehaviorArrayId] = j;
				}
				
				for (var key in inPuppet.behaviorBag) {
					if (inPuppet.behaviorBag.hasOwnProperty(key)) {
						var curTrackItemBehavior = inPuppet.behaviorBag[key];
						Z.utils.assert(curTrackItemBehavior._boundBehaviorArrayID === key);
						
						var stageBehavior = inPuppet.stageBehaviorsArray[stageArrayIdtoIndex[key]];
						
						if (stageBehavior && stageBehavior.boundBehaviorArrayId === key) {
							stageBehavior.trackItemBehavior = curTrackItemBehavior;
							// We only record behaviors if they are in the root scene
							stageBehavior.trackItemBehavior._bArmedForRecord = isRootSceneB0 && stageBehavior.trackItemBehavior._bArmedForRecord && inPuppet.getTrack().getArmedForRecord();

							var egk = "/" + stageBehavior.behaviorId + "/";

							// We now publish these when we compile, but not immediately.  Always use
							// published values over static values. This assumes that if the puppet
							// value is published, and the track item value should be used, the
							// track item value was published too.  -jacquave
							var params = Z.behaviorUtils.prepParamBagForMergingIntoSkeleton(curTrackItemBehavior._paramBag);
							Z.behaviorUtils.mergeParams(params, egk, addParameterIdToTrackItemBehavior(curTrackItemBehavior._instanceID), stageBehavior.pGetParams());
						}
					}
				}				

				inPuppet.getLayers().forEach(function (l) {
					var puppetChild = l.getPuppet(), bindingId, instanceInfo;
					
					if (puppetChild) {
						bindingId = l.getBindingId();
						if (bindingId) {
							instanceInfo = inInstanceInfo._children[bindingId];
							if (instanceInfo) {
								prepPuppetBehaviorInstances(puppetChild, instanceInfo, isRootSceneB0);
							}
						}
					}
				});
			}
			
			function storeInitialVisibilityForLayersInPuppet (inOutPuppet)
			{
				// note: this is currently called _after_ prepPuppetBehaviors, which means onCreateXXX methods have been called and
				//	may have changed visibility already -- seems good to allow behaviors influence this state, which is what will be
				//	restored on each frame, but could bite us with badly behaved behaviors.
				
				inOutPuppet.getParentLayer().getSdkLayer().forEachDirectChildLayer(function (lay) {
					lay.privateLayer.bInitialVisibility = lay.getVisible();
					//console.logToUser("bInitialVisibility for " + lay.getName() + " = " + lay.privateLayer.bInitialVisibility);
				});
			}

			function parsePuppetSuccessFn(puppetParent, trackCPath, isRootSceneB0) 
			{   
				log("puppetParent = " + puppetParent);
				return function (inData)  { 
					log("Run engine.js ...");

					function loadPuppet(varArgs)
					{
						log("loadPuppet");

						log("scene = " + scene);

						log("Request load...");
						Z.Serialize.loadData(inData, function (aContainers, puppet) {
							log("Loading done...");

							log("Make stage...");
							puppetParent.setSourcePuppet(puppet);
							puppetParent.displayInView(stage, true);

							puppet.breadthFirstEach(function (p) {
								prepPuppetBehaviors(p, trackCPath);
							});
							prepPuppetBehaviorInstances(puppet, puppetParent.getInstanceInfo && puppetParent.getInstanceInfo(), isRootSceneB0);
							
							puppet.breadthFirstEach(function (p) {
								// I previously had this inside the prepPuppetBehaviors above, but that walk skips puppets with no
								//	behaviors, so we need another walk here
								storeInitialVisibilityForLayersInPuppet(p);
							});
						});
					}

					var args = Array.prototype.slice.call(arguments);
					loadPuppet(args);
				};
			}

			parseChildrenFunc = function (scene, isRootSceneB0)
			{
				log("print Scene Data...");
				var tracks = scene.getChildren(), t, ti, track, trackItems, trackItem, parsePuppet, trackCPathStr, audioClip;

				log("Scene Data, track length = " + tracks.length);
				for (t = tracks.length-1; t >= 0; t -= 1) {
					track = tracks[t];
					trackItems = track.getChildren();
					log("Scene Data, track items length = " + trackItems.length);
					for (ti=0; ti < trackItems.length; ti += 1) {
						trackItem = trackItems[ti];

						trackCPathStr = ":_aTracks:" + (t+1) + ":_trackItem:" + (ti+1);

						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {
							parsePuppet = parsePuppetSuccessFn(trackItem, trackCPath + trackCPathStr, isRootSceneB0);

							log("Puppet = " + trackItem.getTrackSource().getJsonPath());
							parseJSON(trackItem.getTrackSource().getJsonPath(), parsePuppet, failFn);
							log("Loading Puppet done...");
							log("trackItem.puppet = " + trackItem.getSourcePuppet());
						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {
							log("Scene = " + trackItem.getTrackSource().getJsonPath());
							log("Loading Scene done...");
							trackItem.scene = parseScene (trackItem.getTrackSource().getJsonPath(), trackCPath + trackCPathStr, trackItem);
							log("trackItem.scene = " + trackItem.scene);
						} else if (trackItem.getTrackSource().getClassInstance() === "AudioFile instance") {
							log("AudioFile = " + trackItem.getTrackSource().getJsonPath());
							log("Loading AudioFile done...");
							trackItem.audioFile = parseAudioFile (trackItem.getTrackSource().getJsonPath(), trackCPath + trackCPathStr);
							log("trackItem.audioFile = " + trackItem.audioFile);
							
							if (trackItem.audioFile.filePath) {
								audioClip = new builder.newAudioMediaClip(trackItem.getTrackSource().getJsonPath() + " Audio Media Clip", trackItem.audioFile.filePath, undefined, trackItem.audioFile.recordedSpeed);
								//Z.TimeItem.prototype.clone.call(trackItem, false, audioClip);
								trackItem.getAudioContainer().addChild(audioClip);
								trackItem.attachToRootAudioContainer(stage.getRootAudioContainer());
							}
						}
					}
				}
			};

			parseChildrenFunc(scene, isRootSceneB);

			return scene;
		}

		function terminateStage() {
			
			lodash.forEach(sceneTerminationFuncsA, function (f) {
				f();
			});
			sceneTerminationFuncsA = [];
			
			if (stage) {
				var rootContainer0 = stage.getRootDisplayContainer(), rootAudioContainer0 = stage.getRootAudioContainer();
				
				if (rootContainer0) {
					rootContainer0.removeChangeNotifiers();
					rootContainer0.removeChildren();
				}
				if (rootAudioContainer0) {
					rootAudioContainer0.removeChangeNotifiers();
					rootAudioContainer0.removeChildren();
				}
				stage = null;
			}
			rootScene = null;
			rootSceneId = null;
		}

		try {
			// note: this not only parses the scene, but also invokes onCreateBackStageBehavior and onCreateStageBehavior
			//	for each behavior
			rootScene = parseScene(__compiledScene);
		} catch (e) {
			if (stage) {
				stage.failedToLoad();
				terminateStage();
			}
			throw e;
		}
		stage.setTerminateNotifier(terminateStage);

		function foldItemsInScene (inTime, inScene, ioTimeStack, foldItem, ioFolded)
		{
			var tracks = inScene.getChildren(), track, trackItems, trackItem,
				t, ti, timeSpan,
				targetDeltaTime = 1 / (inScene.getFrameRate() * inScene.getSimulationRateFactor()),
				rootSceneB = ioTimeStack === undefined;

			if (rootSceneB) {
				ioTimeStack = new Z.TimeStack();
				ioTimeStack.pushTime(null, inScene, {t:inTime, dt:targetDeltaTime});
			}
			
			// reverse order so that scene-level behaviors go last
			t = tracks.length;
			while (--t >= 0) {
				track = tracks[t];

				ioTimeStack.pushTime(inScene, track);

				trackItems = track.getChildren();
				
				for (ti=0; ti < trackItems.length; ti += 1) {
					trackItem = trackItems[ti];
					timeSpan = ioTimeStack.pushTime(track, trackItem);
					// console.logToUser("timeSpan: " + timeSpan.t);

					foldItem(trackItem, timeSpan.t, ioTimeStack, ioFolded);

					ioTimeStack.popTime();
				}
				
				ioTimeStack.popTime();
			}

			if (rootSceneB) {
				ioTimeStack.popTime();
				Z.utils.assert(ioTimeStack.getSize() === 0, "Time Stack not balanced");
			}

			return ioFolded;
		}

		function foldActiveItemsInScene (inTime, inScene, ioTimeStack, foldPuppetItem, foldSceneItem, ioFolded)
		{
			function foldItem (item, inTime, ioTimeStack, ioFolded) {
				var visibleB = item.isActivateAtTime(inTime);

				// if (item.getSourcePuppet()) {
				// 	console.logToUser(item.getSourcePuppet().getName() + ": " + visibleB + ", " + inTime + ", " + item.getTrimInTime() + ", " + item.getTrimOutTime() + ", " + ioTimeStack.getSize());
				// }

				if (visibleB) {
					if (item.getTrackSource().getClassInstance() === "Puppet instance") {
						foldPuppetItem(item, ioFolded);
					} else if (item.getTrackSource().getClassInstance() === "Scene instance") {
						foldSceneItem(item, inTime, ioTimeStack, ioFolded);
					}
				}
			}

			return foldItemsInScene(inTime, inScene, ioTimeStack, foldItem, ioFolded);
		}

		function deepGetActivePuppets (inTime, inScene, ioTimeStack, ioPuppets) {
			function foldPuppetItem (item, ioFolded) {
				if (item.getSdkLayer().privateLayer.isScenePuppetLayer()) {
					ioFolded.scene.push(item.getSourcePuppet());
				} else {
					ioFolded.track.push(item.getSourcePuppet());
				}
			}

			function foldSceneItem (item, inTime, ioTimeStack, ioFolded) {
				deepGetActivePuppets(null, item.scene, ioTimeStack, ioFolded);
			}

			ioPuppets = ioPuppets || { scene: [], track: [] };
			ioTimeStack = ioTimeStack || undefined;
			foldActiveItemsInScene(inTime, inScene, ioTimeStack, 
				foldPuppetItem, foldSceneItem, ioPuppets);

			return ioPuppets;
		}

		function getTrackPuppets (inTime, inScene, ioTimeStack, ioTrackPuppets) {
			function foldPuppetItem (item, ioFolded) {
				// skip scene puppets
				if ( !item.getSdkLayer().privateLayer.isScenePuppetLayer() ) {
					ioFolded.push(item.getSourcePuppet());
				}
			}

			function foldSceneItem (item, inTime, ioTimeStack, ioFolded) {
				// console.logToUser("scene: " + item.scene.getTrackItemSource().getPPathString());
				getTrackPuppets(null, item.scene, ioTimeStack, ioFolded);
			}

			ioTrackPuppets = ioTrackPuppets || [];
			ioTimeStack = ioTimeStack || undefined;
			foldActiveItemsInScene(inTime, inScene, ioTimeStack, 
				foldPuppetItem, foldSceneItem, ioTrackPuppets);

			return ioTrackPuppets;
		}

/* FIXME: remove on dead-code pass
		function getScenePuppets (inTime, inScene, ioTimeStack, ioTrackPuppets) {
			function foldPuppetItem (item, ioFolded) {
				// skip track puppets
				if (item.getSdkLayer().privateLayer.isScenePuppetLayer()) {
					ioFolded.push(item.getSourcePuppet());
				}
			}

			function foldSceneItem (item, inTime, ioTimeStack, ioFolded) {
				// console.logToUser("scene: " + item.scene.getTrackItemSource().getPPathString());
				getScenePuppets(null, item.scene, ioTimeStack, ioFolded);
			}

			ioTrackPuppets = ioTrackPuppets || [];
			ioTimeStack = ioTimeStack || undefined;
			foldActiveItemsInScene(inTime, inScene, ioTimeStack, 
				foldPuppetItem, foldSceneItem, ioTrackPuppets);

			return ioTrackPuppets;
		}
/* */		

/* FIXME: remove after refactored version checks out
		function getTrackPuppetsOld (inTime, inScene, ioTimeStack, ioTrackPuppetsArray)
		{
			var tracks = inScene.getChildren(), track, trackItems, trackItem, trackPuppets = ioTrackPuppetsArray || [], 
				t, ti, timeSpan, visibleB, 
				targetDeltaTime = 1 / (inScene.getFrameRate() * inScene.getSimulationRateFactor()),
				rootSceneB = ioTimeStack === undefined;

			if (rootSceneB) {
				ioTimeStack = new Z.TimeStack();
				ioTimeStack.pushTime(null, inScene, {t:inTime, dt:targetDeltaTime});
			}
			
			// reverse order so that scene-level behaviors go last
			t = tracks.length;
			while (--t >= 0) {
				track = tracks[t];

				ioTimeStack.pushTime(inScene, track);

				trackItems = track.getChildren();
				
				for (ti=0; ti < trackItems.length; ti += 1) {
					trackItem = trackItems[ti];
					timeSpan = ioTimeStack.pushTime(track, trackItem);
					// console.logToUser("timeSpan: " + timeSpan.t);
					visibleB = trackItem.isActivateAtTime(timeSpan.t);

					// if (trackItem.getSourcePuppet()) {
					// 	console.logToUser(trackItem.getSourcePuppet().getName() + ": " + visibleB + ", " + timeSpan.t + ", " + trackItem.getTrimInTime() + ", " + trackItem.getTrimOutTime() + ", " + ioTimeStack.getSize());
					// }

					if (visibleB) {
						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {
							trackPuppets.push(trackItem.getSourcePuppet());
						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {
							// console.logToUser("scene: " + trackItem.scene.getTrackItemSource().getPPathString());
							getTrackPuppetsOld(null, trackItem.scene, ioTimeStack, trackPuppets);
						}

					}
					ioTimeStack.popTime();
				}
				
				ioTimeStack.popTime();
			}

			return trackPuppets;
		}
/* */

		function doMediateTriggers (trackPuppet)
		{
			// four kinds of layers at this point: 1) untriggerable, 2) triggerable&untriggered, 3) triggerable&triggered, 4) triggerable&triggered&hideOthers
			//	#1 is hidden if there are any #4
			//	#2 is hidden
			//  #3 & #4 are shown
			//	have to be careful about n-squared iteration
			function setVisibilityRecursive(layer) // for this sdk layer, we operate on its children only, then recurse
			{
				var aShow = [], aHide = [], aUntriggered = [], bHideAllUntriggered = false, i, assert = Z.utils.assert;
				
				layer.forEachDirectChildLayer(function (child) {
					var bDefaultVis = child.privateLayer.bInitialVisibility;
					
					assert(bDefaultVis !== undefined, "missing bInitialVisibility");
					
					//console.logToUser(child.getName() + " bInitialVisibility " + child.privateLayer.bInitialVisibility);
					child.setVisible(bDefaultVis); // start out at default (for untriggerable layers)
					
					// NOTE: currently all hiding/showing is happening via triggers, but if oneday we want to allow behaviors
					//	to call setVisible and have it work, this restoring to bDefaultVis will need happen as a pass in doPreMediate()
					//	Then again, we may need to put back the replacements mediator to avoid setVisible conflicts between behaviors.
					
					if (child.getTriggered() && !bHideAllUntriggered) { // only allow a single mutex
						aShow.push(child);
						if (child.privateLayer.bHideSiblingsWhenTriggered) {
							bHideAllUntriggered = true;
						}
					} else {
						aUntriggered.push(child);
						if (child.privateLayer.getTriggerable()) {
							aHide.push(child);
						}
					}
				});
				
				if (bHideAllUntriggered) {
					aHide = aUntriggered;
				}
				
				for (i=0; i < aHide.length; i += 1) {
					aHide[i].setVisible(false);
					//console.logToUser("hiding " + aHide[i].getName());
				}
				
				for (i=0; i < aShow.length; i += 1) {
					var child = aShow[i];
					child.setVisible(true);
					//console.logToUser("showing " + child.getName());
				}
				
				layer.forEachDirectChildLayer(function (child) {
					if (child.getVisible()) { // covers all aShow layers, plus layers not shown or hidden (not triggerable) 
						setVisibilityRecursive(child);	// only recurse when visible
					}
				});
			}

			// for this trackItem puppet, setVisibilityRecursive
			setVisibilityRecursive(trackPuppet.getTrackItem().getSdkLayer());
		}
		
		function doPreMediate (inSceneTime, inScene, resetRehearsalStateB, puppets0)
		{
			var puppets = puppets0 || getTrackPuppets(inSceneTime, inScene);

			lodash.forEach(puppets, function (p) {
				var layer = p.getParentLayer().getSdkLayer().privateLayer;
				layer.prepareState(resetRehearsalStateB);
			});
		}

		function doPostMediate (inSceneTime, inScene, puppets0) {
			var trackPuppets = puppets0 || getTrackPuppets(inSceneTime, inScene);

			trackPuppets.forEach(function (p) {
				doMediateTriggers(p);
				var puppetSdkLayer = p.getParentLayer().getSdkLayer();

				puppetSdkLayer.privateLayer.commitState();

				// FIXME: eliminate so that we don't have to touch every layer
				puppetSdkLayer.forEachLayerBreadthFirst(function (sdkLayer) {
					sdkLayer.clearSharedFrameData(); 
					sdkLayer.privateLayer.clearPerFrameTriggerData();
				});
			});
		}

		function doAnimatePuppet (inTrackItem, inEventGraph, ioTimeStack, inRehearseTime, resetRehearsalStateB, ioCacheObj)
		{
			return function (p)
			{
				if (p.stageBehaviorsArray) {
					var j, i, recordingB, stoppedB, parentLayer = p.getParentLayer();

					if (!ioCacheObj.transportState) {
						ioCacheObj.transportState = {	recordingB:(stage.isRecording() || stage.isRecordingPending()), 
													 	stoppedB:stage.isStopped()};
					}
					recordingB = ioCacheObj.transportState.recordingB;
					stoppedB = ioCacheObj.transportState.stoppedB;
					
					// Restore the blend mode to the original state.  This could be moved to post mediate,
					// but that would currently be less efficient since it would require an extra iteration.
					// It currently iterates twice over the tree, and I'd rather not add a third iteration.  -jacquave 11/18/2016
					parentLayer.setBlendMode(parentLayer.getBindingBlendMode());

					for (j = 0; j < p.stageBehaviorsArray.length; j += 1) {
						if (p.behaviorJSModules) {
							var module = p.behaviorJSModules[j], behavior = p.stageBehaviorsArray[j], behaviorInstanceId, foundEGPileItems = {},
										eventGraphEvaluators = {}, behaviorRehearseTime = inRehearseTime, behaviorArmedB = false, behaviorLiveB = false;

							behaviorInstanceId = behavior.trackItemBehavior && behavior.trackItemBehavior._instanceID;
							if (!behaviorInstanceId) {
								continue;		// eyeball off behavior
							}
							
							if (behavior.trackItemBehavior && behavior.trackItemBehavior._egPile) {
								behaviorArmedB = behavior.trackItemBehavior._bArmedForRecord;
								behaviorLiveB = behaviorArmedB && (stoppedB || recordingB);

								if (stoppedB && !behaviorArmedB) {
									behaviorRehearseTime = 0.0; // ignore preview time when evaluating the event graphs.
								}

								var egPile = behavior.trackItemBehavior._egPile._aPileItems;
								for (i = egPile.length-1; i >= 0; i -= 1) {
									var egPileItem = egPile[i];

									var	paramId = egPileItem.getParamId(), paramAndTakeGroupId =  egPileItem.getParamAndTakeGroupId();
									if ((foundEGPileItems[paramAndTakeGroupId] === undefined || foundEGPileItems[paramAndTakeGroupId] < 1.0) && 
																	behavior.params[paramId]) {
										var paramLiveB = false;
										
										// Only check whether the param once, not for every take.
										if (foundEGPileItems[paramAndTakeGroupId] === undefined) {
										    paramLiveB = behaviorLiveB && isParamArmedForRecord(inEventGraph, behavior, paramId);
										}

										if (!paramLiveB) {
											// Last overrides prior, so start from the bottom.
											var timeSpan = ioTimeStack.pushTime(inTrackItem, egPileItem);

											if (egPileItem.isActivateAtTime(timeSpan.t)) {
												var evaluator = inEventGraph.getEvaluator(behaviorInstanceId, timeSpan, egPileItem),
													weightF = evaluator.getBlendWeight();
												
												if (foundEGPileItems[paramAndTakeGroupId] === undefined) {
													foundEGPileItems[paramAndTakeGroupId] = weightF;
												} else {
													foundEGPileItems[paramAndTakeGroupId] = 
															Z.mathUtils.getCompositeWeightSum(foundEGPileItems[paramAndTakeGroupId], weightF);
												}
												
												if (eventGraphEvaluators[paramAndTakeGroupId] === undefined) {
													eventGraphEvaluators[paramAndTakeGroupId] = [];
												}
												eventGraphEvaluators[paramAndTakeGroupId].push(evaluator);
											}

											ioTimeStack.popTime();
										} else {
											foundEGPileItems[paramAndTakeGroupId] = 1.0; // Prevents further checking.
										}
									}
								}
							}
							var args = new BehaviorParamBlock(rootScene, behavior, behaviorInstanceId, inEventGraph, ioTimeStack, inRehearseTime, behaviorRehearseTime, behaviorLiveB, p, eventGraphEvaluators);
							
							if (resetRehearsalStateB) {
								if (module.onResetRehearsalData) {
									module.onResetRehearsalData(behavior);
								}
							}
							
							if (args.behaviorLiveB && module.onFilterLiveInputs) {
								args.currentTime = Z.nml.getCurrentTime();
								module.onFilterLiveInputs(behavior, args);
								delete args.currentTime;
							}
 							// Uncomment to log when each behavior runs onAnimate() call.  Helpful when testing how each set handle automation.
							//var ct = Z.nml.getCurrentTime();
							//console.logToUser("onAnimate() for " + module.uiName + ", " +  p.getName());
							module.onAnimate(behavior, args);
							//console.logToUser("onAnimate() for " + module.uiName + " finished. " + (Z.nml.getCurrentTime() - ct) * 1000.0 + " ms");
						}
					}
				}
			};
		}

		doSceneAnimate = function (inSceneTime, inRehearseTime, inScene, ioTimeStack, resetRehearsalStateB, ioCacheObj0) {
			var eventGraph;

			ioCacheObj0 = ioCacheObj0 || {};
			eventGraph = Z.nml.getEventGraph(rootScene.getTrackItemSource().getPPathString());

			// FIXME: Remove once confirming that doing this for track puppets is sufficient.
			// const rootSceneB = (ioTimeStack === undefined);
			// if (resetRehearsalStateB && rootSceneB && eventGraph) {
			//     console.log("onAnimate rehearsal data will be reset.");
			//     eventGraph.removeGraphs("BehaviorOutput/");
			// }

			function foldItem (item, inTime, ioTimeStack, ioArgs) {
				var visibleB = item.isActivateAtTime(inTime);

				// FIXME: Remove once confirming that doing thnis for track puppets is sufficient.
				// if (item.getDisplayContainer && item.getDisplayContainer() && visibleB !== item.getDisplayContainer().getVisibleEnabled()) {
				// 	item.getDisplayContainer().setVisibleEnabled(visibleB);
				// }

				if (visibleB) {
					if (item.getTrackSource().getClassInstance() === "Puppet instance") {

						// only scene-level puppets, skip track-level puppets
						if ( item.getSdkLayer().privateLayer.isScenePuppetLayer() ) {
							item.getSourcePuppet().breadthFirstEach(doAnimatePuppet(item, eventGraph, ioTimeStack, ioArgs.inRehearseTime, ioArgs.resetRehearsalStateB, ioArgs.ioCacheObj0));
						}

					} else if (item.getTrackSource().getClassInstance() === "Scene instance") {

						// and burrow in to find scene-level puppets in nested scenes
						doSceneAnimate(null, ioArgs.inRehearseTime, item.scene, ioTimeStack, ioArgs.resetRehearsalStateB, ioArgs.ioCacheObj0);

					}
				}
			}

			foldItemsInScene(inSceneTime, inScene, ioTimeStack, 
				foldItem,
				{ inRehearseTime, resetRehearsalStateB, ioCacheObj0	});


			// FIXME: Remove once confirming that doing thnis for track puppets is sufficient.
			// if (!firstCalled && stage) {
			// 	stage.setCurtainsOpen(true);
			// } else if (rootSceneB && eventGraph ) {
			//     eventGraph.update(inSceneTime, inRehearseTime);
			// }

			const rootSceneB = (ioTimeStack === undefined);
			if (rootSceneB && eventGraph ) {
			    eventGraph.update(inSceneTime, inRehearseTime);
			}

		};

		doAnimate = function (inSceneTime, inRehearseTime, inScene, ioTimeStack, resetRehearsalStateB, ioCacheObj0) {
			var eventGraph,
				firstCalled = firstAnimateCalled;

			ioCacheObj0 = ioCacheObj0 || {};
			firstAnimateCalled = true;
			eventGraph = Z.nml.getEventGraph(rootScene.getTrackItemSource().getPPathString());

			const rootSceneB = (ioTimeStack === undefined);
			if (resetRehearsalStateB && rootSceneB && eventGraph) {
			    console.log("onAnimate rehearsal data will be reset.");
			    eventGraph.removeGraphs("BehaviorOutput/");
			}

			function foldItem (item, inTime, ioTimeStack, ioArgs) {
				var visibleB = item.isActivateAtTime(inTime);

				if (item.getDisplayContainer && item.getDisplayContainer() && visibleB !== item.getDisplayContainer().getVisibleEnabled()) {
					item.getDisplayContainer().setVisibleEnabled(visibleB);
				}

				if (visibleB) {
					if (item.getTrackSource().getClassInstance() === "Puppet instance") {
						// skip scene puppets
						if ( !item.getSdkLayer().privateLayer.isScenePuppetLayer() ) {
							item.getSourcePuppet().breadthFirstEach(doAnimatePuppet(item, eventGraph, ioTimeStack, ioArgs.inRehearseTime, ioArgs.resetRehearsalStateB, ioArgs.ioCacheObj0));
						}

					} else if (item.getTrackSource().getClassInstance() === "Scene instance") {

						doAnimate(null, ioArgs.inRehearseTime, item.scene, ioTimeStack, ioArgs.resetRehearsalStateB, ioArgs.ioCacheObj0);

					}
				}
			}

			foldItemsInScene(inSceneTime, inScene, ioTimeStack, 
				foldItem,
				{ inRehearseTime, resetRehearsalStateB, ioCacheObj0	});


			if (!firstCalled && stage) {
				stage.setCurtainsOpen(true);
			} else if (rootSceneB && eventGraph ) {
			    eventGraph.update(inSceneTime, inRehearseTime);
			}
		};

/* FIXME: original version. remove after refactored one checks out.
		doAnimate = function (inSceneTime, inRehearseTime, inScene, ioTimeStack, resetRehearsalStateB, ioCacheObj0) {
			var tracks = inScene.getChildren(), visibleB, timeSpan, t, ti, track, trackItems, trackItem, eventGraph,
				targetDeltaTime = 1 / (inScene.getFrameRate() * inScene.getSimulationRateFactor()), firstCalled = firstAnimateCalled, 
				rootSceneB = ioTimeStack === undefined;

			ioCacheObj0 = ioCacheObj0 || {};
			if (rootSceneB) {
				ioTimeStack = new Z.TimeStack();
				ioTimeStack.pushTime(null, inScene, {t:inSceneTime, dt:targetDeltaTime});
			}
			
			firstAnimateCalled = true;
			eventGraph = Z.nml.getEventGraph(rootScene.getTrackItemSource().getPPathString());
			
			if (resetRehearsalStateB && rootSceneB && eventGraph) {
			    console.log("onAnimate rehearsal data will be reset.");
			    eventGraph.removeGraphs("BehaviorOutput/");
			}

			for (t = tracks.length-1; t >= 0; t -= 1) {
				track = tracks[t];

				ioTimeStack.pushTime(inScene, track);

				trackItems = track.getChildren();
				
				for (ti=0; ti < trackItems.length; ti += 1) {
					trackItem = trackItems[ti];

					timeSpan = ioTimeStack.pushTime(track, trackItem);

					visibleB = trackItem.isActivateAtTime(timeSpan.t);

					if (trackItem.getDisplayContainer && trackItem.getDisplayContainer() && visibleB !== trackItem.getDisplayContainer().getVisibleEnabled()) {
						trackItem.getDisplayContainer().setVisibleEnabled(visibleB);
					}

					if (visibleB) {
						if (trackItem.getTrackSource().getClassInstance() === "Puppet instance") {

							trackItem.getSourcePuppet().breadthFirstEach(doAnimatePuppet(trackItem, eventGraph, ioTimeStack, inRehearseTime, resetRehearsalStateB, ioCacheObj0));

						} else if (trackItem.getTrackSource().getClassInstance() === "Scene instance") {

							doAnimate(null, inRehearseTime, trackItem.scene, ioTimeStack, resetRehearsalStateB, ioCacheObj0);

						}
					}
					ioTimeStack.popTime();
				}
				
				ioTimeStack.popTime();
			}

			if (rootSceneB) {
				ioTimeStack.popTime();
				Z.utils.assert(ioTimeStack.getSize() === 0, "Time Stack not balanced");
			}
			
			if (!firstCalled && stage) {
				stage.setCurtainsOpen(true);
			} else if (rootSceneB && eventGraph ) {
			    eventGraph.update(inSceneTime, inRehearseTime);
			}
		};
/* */
		if (stage && rootScene) 
		{
			var	lastRehearsalId = 1;
			stage.addTimerNotifier(
				function (inSceneTime, inRehearseTime, inRehearsalId) {
					var resetRehearsalStateB = (lastRehearsalId !== inRehearsalId),
                        incrementTimestamp = (config.MutableTree.enabled ? tasks.dofs.Tree.incrementTimestamp : function () {});
                    
                    incrementTimestamp();

					var tPuppets = deepGetActivePuppets(inSceneTime, rootScene);

					//var ct = Z.nml.getCurrentTime();
					ZoneProfiler.push("doPreMediate");
					//console.logToUser("onAnimate() called at sceneTime=" + inSceneTime + ", rehearsalTime=" + inRehearseTime);
					//var ct1 = Z.nml.getCurrentTime();
					doPreMediate(inSceneTime, rootScene, resetRehearsalStateB, tPuppets.track);
					//console.logToUser("doPreMediate() finished. " + (Z.nml.getCurrentTime() - ct1) * 1000.0 + " ms");
					ZoneProfiler.pop("doPreMediate");

					ZoneProfiler.push("doAnimate");
					//var ct3 = Z.nml.getCurrentTime();
					doAnimate(inSceneTime, inRehearseTime, rootScene, undefined, resetRehearsalStateB);
					//console.logToUser("doAnimate() finished. " + (Z.nml.getCurrentTime() - ct3) * 1000.0 + " ms");
					ZoneProfiler.pop("doAnimate");

					ZoneProfiler.push("doPostMediate");
					//var ct2 = Z.nml.getCurrentTime();
					doPostMediate(inSceneTime, rootScene, tPuppets.track);
					//console.logToUser("doPostMediate() finished. " + (Z.nml.getCurrentTime() - ct2) * 1000.0 + " ms");
					ZoneProfiler.pop("doPostMediate");

                    incrementTimestamp();

                    ZoneProfiler.push("doSceneAnimate");
					doSceneAnimate(inSceneTime, inRehearseTime, rootScene, undefined, resetRehearsalStateB);
					ZoneProfiler.pop("doSceneAnimate");

					ZoneProfiler.report(10);
					
					lastRehearsalId = inRehearsalId;
					//console.logToUser("Stage onAnimate() finished. Total : " + (Z.nml.getCurrentTime() - ct) * 1000.0 + " ms");
				}
			);
			
			stage.readyForAction();
		}
	});
} ());
